<?php

namespace Google\Site_Kit_Dependencies\Psr\Http\Client;

use Google\Site_Kit_Dependencies\Psr\Http\Message\RequestInterface;
/**
 * Thrown when the request cannot be completed because of network issues.
 *
 * There is no response object as this exception is thrown when no response has been received.
 *
 * Example: the target host name can not be resolved or the connection failed.
 */
interface NetworkExceptionInterface extends \Google\Site_Kit_Dependencies\Psr\Http\Client\ClientExceptionInterface
{
    /**
     * Returns the request.
     *
     * The request object MAY be a different object from the one passed to ClientInterface::sendRequest()
     *
     * @return RequestInterface
     */
    public function getRequest() : \Google\Site_Kit_Dependencies\Psr\Http\Message\RequestInterface;
}
